/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import teamdraco.unnamedanimalmod.init.UAMItems;
import teamdraco.unnamedanimalmod.init.UAMSounds;

public class MarineIguanaEntity
extends AnimalEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(MarineIguanaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int timeUntilNextSneeze;
    private UUID lightningUUID;
    private boolean didSneeze;

    public MarineIguanaEntity(EntityType<? extends MarineIguanaEntity> type, World world) {
        super(type, world);
        this.timeUntilNextSneeze = this.field_70146_Z.nextInt(8000) + 8000;
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 1.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator(this, this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int func_70627_aG() {
        return 360;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 2.0, 1){

            public boolean func_75250_a() {
                return super.func_75250_a() && MarineIguanaEntity.this.func_70090_H();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new WanderGoal(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new GoToWaterGoal(this, 1.0));
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_221600_aB;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return 10.0f;
        }
        return 1.5f;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextSneeze <= 0) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            this.func_199701_a_(new ItemStack((IItemProvider)UAMItems.SALT.get(), this.field_70146_Z.nextInt(4)));
            MarineIguanaEntity iguanaEntity = this;
            this.timeUntilNextSneeze = this.field_70146_Z.nextInt(8000) + 6000;
            this.didSneeze = true;
            iguanaEntity.setDidSneeze(false);
        }
    }

    public static boolean canAnimalSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150348_b) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(4));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("SneezeTime", this.timeUntilNextSneeze);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        if (compound.func_74764_b("SneezeTime")) {
            this.timeUntilNextSneeze = compound.func_74762_e("SneezeTime");
        }
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        UUID uuid = p_241841_2_.func_110124_au();
        if (!uuid.equals(this.lightningUUID)) {
            this.setVariant(4);
            this.lightningUUID = uuid;
            this.func_184185_a((SoundEvent)UAMSounds.MARINE_IGUANA_TRANSFORMS.get(), 2.0f, 1.0f);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        this.func_199701_a_(new ItemStack((IItemProvider)UAMItems.MARINE_IGUANA_EGG.get(), this.func_70681_au().nextInt(1) + 1));
        this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        ((AnimalEntity)p_241840_2_).func_70875_t();
        return null;
    }

    private void setDidSneeze(boolean didSneezeIn) {
        this.didSneeze = didSneezeIn;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)UAMSounds.MARINE_IGUANA_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UAMSounds.MARINE_IGUANA_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)UAMSounds.MARINE_IGUANA_HURT.get();
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.MARINE_IGUANA_SPAWN_EGG.get());
    }

    static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final MarineIguanaEntity iguana;

        private GoToWaterGoal(MarineIguanaEntity iguana, double speedIn) {
            super((CreatureEntity)iguana, iguana.func_70631_g_() ? 2.0 : speedIn, 24);
            this.iguana = iguana;
            this.field_203112_e = -1;
        }

        public boolean func_75253_b() {
            return !this.iguana.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)this.iguana.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.iguana.func_70631_g_() && !this.iguana.func_70090_H()) {
                return super.func_75250_a();
            }
            return !this.iguana.func_70090_H() && super.func_75250_a();
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j);
        }
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final MarineIguanaEntity iguana;

        private WanderGoal(MarineIguanaEntity iguana, double speedIn, int chance) {
            super((CreatureEntity)iguana, speedIn, chance);
            this.iguana = iguana;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }

    static class Navigator
    extends SwimmerPathNavigator {
        Navigator(MarineIguanaEntity iguana, World worldIn) {
            super((MobEntity)iguana, worldIn);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            if (this.field_75515_a instanceof MarineIguanaEntity) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final MarineIguanaEntity iguana;

        MoveHelperController(MarineIguanaEntity iguana) {
            super((MobEntity)iguana);
            this.iguana = iguana;
        }

        private void updateSpeed() {
            if (this.iguana.func_70090_H()) {
                this.iguana.func_213317_d(this.iguana.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (this.iguana.func_70631_g_()) {
                    this.iguana.func_70659_e(Math.max(this.iguana.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.iguana.field_70122_E) {
                this.iguana.func_70659_e(Math.max(this.iguana.func_70689_ay() / 1.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.iguana.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.iguana.func_226277_ct_();
                double d1 = this.field_75647_c - this.iguana.func_226278_cu_();
                double d2 = this.field_75644_d - this.iguana.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.iguana.field_70761_aq = this.iguana.field_70177_z = this.func_75639_a(this.iguana.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.iguana.func_233637_b_(Attributes.field_233821_d_));
                this.iguana.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.iguana.func_70689_ay(), (float)f1));
                this.iguana.func_213317_d(this.iguana.func_213322_ci().func_72441_c(0.0, (double)this.iguana.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.iguana.func_70659_e(0.0f);
            }
        }
    }
}

